/*
As well as reading live values and invoking Actions, we can also manipulate
the Components running in a Station. For instance, we can add, remove, reorder or
rename information!

In this example, we're going to commission a driver using BajaScript...

- baja.$(typeSpec) is used to create new BajaScript Objects/Components.
- BajaScript Components have the same accessors as their Server based counterparts.
- The 'Drivers' Component is resolved from an ORD and is subscribed. It's a remote version of the real 'Drivers' Component on the Station.
- Adding to a proxy Component (i.e. drivers), results in a network call and adds to the real Component in the Server. Please note, the network call is asynchronous!
- BajaScript can be used to access enumerations.
- baja.SlotPath.escape(...) is used to ensure the Slot name is valid.

See the JsDocs for baja.Component to see what other methods are available.
*/

// The name of the device network
var deviceNetworkName = baja.SlotPath.escape("BsModbusNetwork");

// Resolve and subscribe to the 'Drivers' Container in the Server
baja.Ord.make("station:|slot:/Drivers").get({
  ok: function (drivers) {
    // Only add the driver if it doesn't already exist!
    if (drivers.has(deviceNetworkName)) {
      baja.outln("Device network already added!");
      return;
    }
    
    // Create and set up a ModbusAsyncNetwork...
    var deviceNetwork = baja.$("modbusAsync:ModbusAsyncNetwork");
    var config = deviceNetwork.getSerialPortConfig();
    config.setPortName("COM1");
    config.setBaudRate(baja.$("serial:SerialBaudRate").get("baud19200"));
    config.setParity(baja.$("serial:SerialParity").get("even"));
    
    // Create and set up a ModbusAsyncDevice...
    var device = baja.$("modbusAsync:ModbusAsyncDevice");     
    device.setDeviceAddress(10);

    // Add the device to the device network (please note, at this point we haven't
    // added any of this to the Station)...
    deviceNetwork.add({
      slot: "myDevice",
      value: device
    });
         
    // Add the device network to the Station. This will add everything we're previously
    // configured...
    drivers.add({
      slot: deviceNetworkName,
      value: deviceNetwork,
      ok: function () {
        baja.outln("Added the device network!");
      }
    });
  },
  lease: true
});

// Note that if other students are also going through this tutorial on this Station right now, then you may see some unexpected results!
